#ifndef HOPCROFT_H
#define HOPCROFT_H

#include <stdio.h>
#include <stdint.h>
#include <stdlib.h>
#include <stdbool.h>
#include <string.h>


struct edge {
    uint32_t beginpos;   /* Begin position of the edge label */
    uint32_t length;     /* Length of the first icharacter */
    uint32_t ilength;    /* Number of Icharacters */
    bool is_first;       /* If the first icharacter is an horizontal (false) or a vertical (true) */
    uint32_t dest;       /* Destination node */
};

struct node {
    uint32_t s;          /* Suffix link */
    struct edge* edges;  /* Array of outgoing edges */
    uint32_t n_edges;    /* Total number of edges */
};

struct edge_partition {
    uint32_t q;          /* Node*/
    uint32_t gamma;      /* Length in icharacters*/
    uint32_t i;          /* Edge label*/
    uint32_t ilength;    /* Number of elements in the path from I to the node q*/
    uint32_t pos;        /* Begin position*/
    bool first;          /* If it is the first icharacter with this length*/
    uint32_t length;     /* Length of the first Icharacter*/
    uint32_t path;       /* Number of row jumps (only computed when find_edge is used more than 2 times)*/
};

struct partition {
    uint32_t* elem;      /* Elements of each set on the partition*/
    uint32_t n_elem;     /* Number of elements of each set on the partition*/
};

struct partition_vect {
    struct partition* result; /* Vector containing the sets of a partition*/
    uint32_t n_result;        /* Number of elements in the vector result*/
};

bool same_partition_array(struct partition* A, size_t len_A, struct partition* B, size_t len_B);
bool same_set(struct partition* a, struct partition* b);
int compare_uint32(const void* a, const void* b);
void set_union(struct partition* set_of_sets, uint32_t n_set_of_sets, struct partition* new_set, uint32_t n_new_set, struct partition* final_set, uint32_t n_final_set, int32_t index);
struct partition_vect* split(struct node* cdaig, struct partition s, struct partition* p, uint32_t np, FILE* data, int n, int m);
void hopcroft(struct node** cdaig, uint32_t* v, FILE* data, int n, int m);


#endif /* HOPCROFT_H */